/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.client;

import com.ibm.hsc.client.PIDataBeanInterface;
import com.ibm.hsc.common.util.CSVRecord;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;

public class PIConnectionDataBean
implements PIDataBeanInterface {
    public static final String KEY_RESOURCE_TYPE = "resource_type";
    public static final String KEY_MTMS = "type_model_serial_num";
    public static final String KEY_SERVICE_PROC = "sp";
    public static final String KEY_SIDE = "side";
    public static final String KEY_IP_ADDRESS = "ipaddr";
    public static final String KEY_STATE = "state";
    public static final int FSP_RESOURCE = 0;
    public static final int BPC_RESOURCE = 1;
    public static final String STRING_FSP_RESOURCE = "sys";
    public static final String STRING_BPC_RESOURCE = "frame";
    public static final String STRING_SP_PRIMARY = "primary";
    public static final String STRING_SP_SECONDARY = "backup";
    public static final String STRING_SP_FAIL_OVER_PRIMARY = "failed primary";
    public static final String STRING_SP_UNKNOWN = "unavailable";
    public static final String STRING_SIDE_A = "a";
    public static final String STRING_SIDE_B = "b";
    public static final String STRING_SIDE_UNKNOWN = "unavailable";
    public static final String[] ALL_KEYS = new String[]{"resource_type", "type_model_serial_num", "sp", "side", "ipaddr", "state"};
    private int m_resourceType;
    private Vector m_mtms = new Vector();
    private Vector m_locCode = new Vector();
    private String m_IPAddress;
    private Vector m_state = new Vector();

    public String[] getAllKeys() {
        return ALL_KEYS;
    }

    public int getResourceType() {
        return this.m_resourceType;
    }

    public Vector getMTMS() {
        return this.m_mtms;
    }

    public Vector getLocCode() {
        return this.m_locCode;
    }

    public String getIPAddress() {
        return this.m_IPAddress;
    }

    public Vector getState() {
        return this.m_state;
    }

    public void setResourceType(int n) {
        this.m_resourceType = n;
    }

    public void setMTMS(Vector vector) {
        this.m_mtms = vector;
    }

    public void setLocCode(Vector vector) {
        this.m_locCode = vector;
    }

    public void setIPAddress(String string) {
        this.m_IPAddress = string;
    }

    public void setState(Vector vector) {
        this.m_state = vector;
    }

    public String toString(String[] stringArray, boolean bl, String string) {
        CSVRecord cSVRecord = new CSVRecord(true, string);
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            CSVRecord cSVRecord2;
            String string2 = stringArray[i];
            if (KEY_RESOURCE_TYPE.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.getResourceTypeString(), bl);
                continue;
            }
            if (KEY_MTMS.equals(string2)) {
                if (this.m_mtms.size() > 0) {
                    cSVRecord2 = new CSVRecord(true, ",");
                    for (n = 0; n < this.m_mtms.size(); ++n) {
                        String string3 = (String)this.m_mtms.get(n);
                        if (string3 == null) {
                            string3 = "unavailable";
                        }
                        cSVRecord2.add(string3);
                    }
                    CSVRecord.append(cSVRecord, string2, cSVRecord2.toString(), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_SERVICE_PROC.equals(string2)) {
                if (this.m_resourceType == 0) {
                    if (this.m_locCode.size() > 0) {
                        cSVRecord2 = new CSVRecord(true, ",");
                        for (n = 0; n < this.m_locCode.size(); ++n) {
                            cSVRecord2.add(this.getLocCodeString((String)this.m_locCode.get(n)));
                        }
                        CSVRecord.append(cSVRecord, string2, cSVRecord2.toString(), bl);
                        continue;
                    }
                    CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                    continue;
                }
                if (bl) continue;
                CSVRecord.append(cSVRecord, string2, (String)null, bl);
                continue;
            }
            if (KEY_SIDE.equals(string2)) {
                if (this.m_resourceType == 1) {
                    if (this.m_locCode.size() > 0) {
                        cSVRecord2 = new CSVRecord(true, ",");
                        for (n = 0; n < this.m_locCode.size(); ++n) {
                            cSVRecord2.add(this.getLocCodeString((String)this.m_locCode.get(n)));
                        }
                        CSVRecord.append(cSVRecord, string2, cSVRecord2.toString(), bl);
                        continue;
                    }
                    CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                    continue;
                }
                if (bl) continue;
                CSVRecord.append(cSVRecord, string2, (String)null, bl);
                continue;
            }
            if (KEY_IP_ADDRESS.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_IPAddress, bl);
                continue;
            }
            if (!KEY_STATE.equals(string2)) continue;
            if (this.m_state.size() > 0) {
                cSVRecord2 = new CSVRecord(true, ",");
                for (n = 0; n < this.m_state.size(); ++n) {
                    cSVRecord2.add(this.getStateString((UnsignedInt16)this.m_state.get(n)));
                }
                CSVRecord.append(cSVRecord, string2, cSVRecord2.toString(), bl);
                continue;
            }
            CSVRecord.append(cSVRecord, string2, "unavailable", bl);
        }
        return cSVRecord.toString();
    }

    public String toString() {
        return "[" + this.toString(ALL_KEYS, true, ",") + "]";
    }

    private String getResourceTypeString() {
        if (this.m_resourceType == 0) {
            return STRING_FSP_RESOURCE;
        }
        return STRING_BPC_RESOURCE;
    }

    private String getLocCodeString(String string) {
        String string2 = "unavailable";
        if (string != null) {
            string2 = string.equals("SIDE_A") ? STRING_SIDE_A : (string.equals("SIDE_B") ? STRING_SIDE_B : (string.startsWith("SIDE_UNKNOWN") ? "unavailable" : (string.equals("PRIMARY") ? STRING_SP_PRIMARY : (string.equals("SECONDARY") ? STRING_SP_SECONDARY : (string.equals("FAIL_OVER_PRIMARY") ? STRING_SP_FAIL_OVER_PRIMARY : (string.startsWith("UNKNOWN") ? "unavailable" : string))))));
        }
        return string2;
    }

    private String getStateString(UnsignedInt16 unsignedInt16) {
        String string = "unavailable";
        if (unsignedInt16 != null) {
            int n = unsignedInt16.intValue();
            string = n == 0 ? "Connected" : (n == 1 ? "Connecting (0001)" : (n == 4 ? "Connecting (0004)" : (n == 8 ? "Connecting (0008)" : (n == 11 ? "Pending Authentication - Password Updates Required" : (n == 4096 ? "Connecting (1000)" : (n == 32768 ? "No Connection" : (n == 32769 ? "No Connection (8001)" : (n == 32770 ? "Connecting" : (n == 32771 ? "Connection Refused" : (n == 32772 ? "No Connection (8004)" : (n == 32773 ? "Failed Authentication" : (n == 32774 ? "No Connection (8006)" : (n == 32775 ? "Version Mismatch" : unsignedInt16.toString())))))))))))));
        }
        return string;
    }
}

